--Sample query to show query plan
select Color, AVG(ListPrice) as 'AvgListPrice', COUNT(*) as 'Count'
from Production.Product
where ProductNumber like 'FR-%'
group by all Color
order by Color desc










--Rank (RANK leaves nos. for equal values, DENSE_RANK does not)
select DENSE_RANK() over (partition by pi.LocationID order by pi.Quantity DESC) as RANK,
       p.Name as Product, l.Name as Location, pi.Quantity
from Production.ProductInventory pi
join Production.Product p
on pi.ProductID = pi.ProductID
join Production.Location l
on pi.LocationID = l.LocationID
order by pi.LocationID, RANK

--NTile
--Split salespeople who have a territory and sales
--into 4 groups base on year-to-date sales
select NTILE(4) over (order by SalesYTD desc) as 'Quartile', sp.SalesYTD, p.FirstName + ' ' + p.LastName as Name
from Sales.SalesPerson sp
join Person.Person p
on sp.BusinessEntityID = p.BusinessEntityID
where TerritoryID is not null and SalesYTD != 0











--Simple grouping (with ALL)
select Color, AVG(ListPrice) as 'AvgListPrice'
from Production.Product
where ProductNumber like 'FR-R%'
group by Color

select Color, AVG(ListPrice) as 'AvgListPrice'
from Production.Product
where ProductNumber like 'FR-R%'
group by all Color









--Grouping with filter
select SalesOrderID, SUM(LineTotal) as SubTotal
from Sales.SalesOrderDetail
group by SalesOrderID
having SUM(LineTotal) > 100000
order by SalesOrderID







--Grouping (normal, rollup & cube)
select ProductID, Shelf, SUM(Quantity) as QtySum
from Production.ProductInventory
where ProductID < 6
group by ProductID, Shelf

select ProductID, Shelf, SUM(Quantity) as QtySum
from Production.ProductInventory
where ProductID < 6
group by rollup(ProductID, Shelf)

select ProductID, Shelf, SUM(Quantity) as QtySum
from Production.ProductInventory
where ProductID < 6
group by cube(ProductID, Shelf)









--Crosstab

--Normal
select Name, Color, SafetyStockLevel
from (SELECT SafetyStockLevel, Color, Name From Production.Product) p
where Color is not null
order by Name

--Pivot
select Name, [Black], [Silver/Black], [Silver], [Grey], 
       [Red], [Blue], [Yellow], [White], [Multi]
from 
	(select SafetyStockLevel, Color, Name 
	 from Production.Product
	 where Color is not null) p
pivot
(
sum(SafetyStockLevel) for color in ([Black], [Silver/Black], [Silver], [Grey], 
                                    [Red], [Blue], [Yellow], [White], [Multi])
) as PVT
order by Name











--Subqueries
--Names of all products priced the same as chainring bolts
select Name, ListPrice
from Production.Product
where ListPrice =
    (select ListPrice
     from Production.Product
     where Name = 'Chainring Bolts')
order by Name;

--CTEs
--Total no. of sales orders and most recent sales order date for each salesperson
with Sales_CTE (SalesPersonID, TotalNumSales, RecentOrderDate) as
(select SalesPersonID, COUNT(*), MAX(OrderDate) 
 from Sales.SalesOrderHeader 
 where SalesPersonID is not null 
 group by SalesPersonID
)
select p.FirstName, p.LastName, s.TotalNumSales, s.RecentOrderDate
from Sales_CTE as s
join Person.Person as p
on s.SalesPersonID = p.BusinessEntityID

--Recursive CTE - builds hierarchical list of product 
--assemblies & components required to build a bike (product ID 800)
with Parts(AssemblyID, ComponentID, PerAssemblyQty, EndDate, ComponentLevel) as
(
    select b.ProductAssemblyID, b.ComponentID, b.PerAssemblyQty,
        b.EndDate, 0 as ComponentLevel
    from Production.BillOfMaterials as b
    where b.ProductAssemblyID = 800
          and b.EndDate is null
    union all
    select bom.ProductAssemblyID, bom.ComponentID, p.PerAssemblyQty,
        bom.EndDate, ComponentLevel + 1
    from Production.BillOfMaterials as bom 
        inner join Parts as p
        ON bom.ProductAssemblyID = p.ComponentID
        and bom.EndDate is null
)
select AssemblyID, ComponentID, Name, PerAssemblyQty, EndDate,
        ComponentLevel 
from Parts as p
    inner join Production.Product as pr
    on p.ComponentID = pr.ProductID
order by ComponentLevel, AssemblyID, ComponentID;
